unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMGauge, StdCtrls, MMDSPObj, MMTrigg, MMMPEG, MMsystem, ExtCtrls,
  MMMPType,MMUtils;

type
  TForm1 = class(TForm)
    MPEGFile: TMMMPEGFile;
    Trigger: TMMTrigger;
    btnScan: TButton;
    Gauge: TMMGauge;
    btnDecode: TButton;
    Label1: TLabel;
    Label2: TLabel;
    lblScan: TLabel;
    lblDecoded: TLabel;
    btnFile: TButton;
    OpenDialog: TOpenDialog;
    Timer: TTimer;
    lblTime: TLabel;
    Label3: TLabel;
    procedure btnFileClick(Sender: TObject);
    procedure btnDecodeClick(Sender: TObject);
    procedure TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure TriggerStart(Sender: TObject);
    procedure TriggerStop(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure TriggerClose(Sender: TObject);
    procedure btnScanClick(Sender: TObject);
  private
    StartTime: Longint;
    DecodedBytes: Longint;
    ScannedBytes: Longint;
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ this demo scans a mpeg file to determine the decoded filesize in bytes }

{------------------------------------------------------------------------------}
procedure TForm1.btnFileClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      MpegFile.FileName := OpenDialog.FileName;

      btnScan.Enabled    := True;
      btnDecode.Enabled  := True;
      lblScan.Caption    := '0';
      lblDecoded.Caption := '0';
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnDecodeClick(Sender: TObject);
begin
   DecodedBytes := 0;
   Trigger.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerStart(Sender: TObject);
begin
   StartTime := TimeGetTime;
   Timer.Enabled := True;
   btnFile.Enabled := False;
   btnScan.Enabled := False;
   btnDecode.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerStop(Sender: TObject);
begin
   lblTime.Caption := TimeToString(TimeGetTime-StartTime);
   Trigger.Close;
   Timer.Enabled := False;
   btnFile.Enabled := True;
   btnScan.Enabled := True;
   btnDecode.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerClose(Sender: TObject);
begin
   lblDecoded.Caption := IntToStr(DecodedBytes);
   Gauge.Progress := 0;
end;

{------------------------------------------------------------------------------}
procedure TForm1.TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   inc(DecodedBytes,lpWaveHdr^.dwBytesRecorded);
end;

{------------------------------------------------------------------------------}
procedure TForm1.TimerTimer(Sender: TObject);
begin
   if (trOpen in Trigger.State) then
   begin
      lblDecoded.Caption := IntToStr(DecodedBytes);
      Gauge.Progress := (MpegFile.Position*100)div MpegFile.Frames;
   end;
end;

{------------------------------------------------------------------------------}
procedure MpegScanProc(dwPercent: integer; dwInstance: DWORD); stdcall;
begin
   with Form1 do
   begin
      if (dwPercent = 100) then
      begin
         Timer.Enabled := False;
         btnFile.Enabled := True;
         btnScan.Enabled := True;
         btnDecode.Enabled := True;
         Gauge.Progress := 0;
      end
      else Gauge.Progress := dwPercent;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnScanClick(Sender: TObject);
begin
   Timer.Enabled := True;
   btnFile.Enabled := False;
   btnScan.Enabled := False;
   btnDecode.Enabled := False;
   MpegFile.ScanFile(False, 0, MpegScanProc);
   if MpegFile.Version <> v1 then
      ScannedBytes := MpegFile.Frames*1152*MpegFile.PWaveFormat.nChannels
   else
      ScannedBytes := MpegFile.Frames*2304*MpegFile.PWaveFormat.nChannels;
   lblScan.Caption := IntToStr(ScannedBytes);
end;

end.
